import numpy as np
import math
import random

class COCO:
    def __init__(self,dictionary):
        self.x_dim = dictionary['x_dim']
        self.constraint_dim =  dictionary['constraint_dim']
        self.A_range = dictionary['A_range']
        self.b_range = dictionary['b_range']

        def formx1t(t):
            a = np.random.uniform(low=-math.pow(t, 1 / 10), high=math.pow(t, 1 / 10), size=(self.x_dim,))
            return a
        #5000 round
        def formx2t(t):
            if t in range(1, 1501):
                return np.random.uniform(low=-1, high=0, size=(self.x_dim,))
            if t in range(2000, 3501):
                return np.random.uniform(low=-1, high=0, size=(self.x_dim,))
            if t in range(4000, 5001):
                return np.random.uniform(low=-1, high=0, size=(self.x_dim,))
            else:
                return np.random.uniform(low=0, high=1, size=(self.x_dim,))

        def formu(T):
            u = random.sample(range(1, T + 1), T)
            return u

        def formx3t(t, u):
            a = np.zeros(2)
            a[0] = math.pow(-1, u[t - 1])
            a[1] = math.pow(-1, u[t - 1])
            return a

        def formxt(t, u):
            x = formx1t(t) + formx2t(t) + formx3t(t, u)
            return x
        #theta in linear loss
        u = formu(5000)
        self.theta = []  # loss functions = z*x
        for i in range(1, 5001):
            self.theta.append(formxt(i, u))

        #constraint
        self.A = np.random.uniform(low=self.A_range[0], high=self.A_range[1], size=(self.constraint_dim, self.x_dim))
        self.b = np.random.uniform(low=self.b_range[0], high=self.b_range[1], size=(self.constraint_dim,))

    def observe(self,round):
        return self.theta[round]



